# Vendor risk decision memo (template)

Use this memo to capture a clear decision trail. Auditors and buyers care about why you approved a vendor, not only what PDFs you collected.

## 1) Vendor profile
- Vendor name:
- Service provided:
- Business owner (internal):
- Renewal date:
- Primary vendor contact:

## 2) Scope and data exposure
- What systems will integrate with the vendor:
- Data categories accessed (high level):
- Access type:
  - No access / indirect / direct
  - Read / write / admin
- Support access model (if applicable):
  - How is access approved?
  - Is access time-boxed?
  - Is access logged and reviewed?

## 3) Inherent risk assessment (summary)
- Data sensitivity: Low / Medium / High. Rationale:
- Access type risk: Low / Medium / High. Rationale:
- Business criticality: Low / Medium / High. Rationale:
- Overall inherent risk: Low / Medium / High

## 4) Evidence reviewed
Reference artifact IDs from `evidence-index-template.csv` and link to where you stored the evidence set.

- Evidence index link:
- Artifacts reviewed:
  - {Artifact ID}: {Artifact name} (captured {YYYY-MM-DD}, expires {YYYY-MM-DD})

## 5) Control assessment (high level)
Summarize what you learned, not vendor marketing language.

- Identity & access:
- Logging & monitoring:
- Vulnerability management:
- Incident response:
- Data protection:
- Vendor/subprocessor management:

## 6) Findings and gaps
List gaps as explicit items. If a gap is acceptable, state compensating controls and timing.

- Finding 1:
  - Risk:
  - Compensating controls:
  - Owner:
  - Target date:

## 7) Decision
- Decision: Approve / Approve with conditions / Reject
- Rationale:
- Conditions (if applicable):
  - Condition 1 (deadline and owner):
  - Condition 2 (deadline and owner):
- Next review date:
- Review triggers: renewal, material change, vendor incident, scope expansion

## Notes
- This template is informational and is not legal advice.
