# Risk rating rubric (simple and repeatable)

Use this rubric to keep vendor decisions consistent across reviewers and over time.

## Step 1: Determine inherent risk
Score each category as Low/Medium/High (or 1/2/3).

1) Data sensitivity
- Low: no customer data, no sensitive internal data
- Medium: limited customer data or non-sensitive internal data
- High: PII/PHI/PCI, secrets, or broad customer data access

2) Access type
- Low: no access to production systems or customer data
- Medium: indirect access (support tooling, limited integrations)
- High: direct access to production data or admin systems

3) Business criticality
- Low: non-critical service; easy to replace
- Medium: important but replaceable
- High: outage blocks core business operations

## Step 2: Determine control strength
Evaluate whether the vendor provides evidence for:
- Identity controls (MFA, least privilege, access reviews)
- Logging and monitoring (audit trails, retention)
- Vulnerability management (scan cadence, remediation process)
- Incident response (plan, timelines, contacts)
- Third-party assurance (SOC 2 / ISO / pen test summaries, if applicable)

## Step 3: Decide
Suggested decision logic:
- Low inherent risk and adequate evidence: Approve
- Medium risk or incomplete evidence: Approve with conditions (time-boxed follow-ups)
- High risk and weak evidence: Escalate for security leadership review or reject

## Step 3b: Typical “approve with conditions” patterns
Use conditions to turn uncertainty into owned follow-ups.

Examples:
- Provide SOC 2 report under agreement within 30 days.
- Provide updated subprocessor list and change notification approach.
- Implement MFA for admin access by {date} and provide evidence export.
- Time-box support access to production and log access by {date}.

Conditions should have:
- Owner (your side and vendor side if applicable)
- Deadline
- Proof required (artifact ID or link)

## Step 4: Record the decision trail
For audit and buyer questions, preserve:
- What was reviewed
- Who reviewed it and when
- The decision and rationale
- Exceptions and compensating controls
- Next review date and triggers (renewal, incident, material change)

## Practical scoring tips
- If the vendor cannot answer what data they access, treat that as high risk until clarified.
- If the vendor refuses to share any evidence (even under agreement), document the gap and escalate.
- If your own scope changes (new integration, new data category), re-score inherent risk.
