# Roles and inject examples

## Recommended roles
- **Facilitator:** runs the scenario, keeps time, asks prompting questions, records decisions
- **Incident commander:** owns decisions and the “official” timeline; delegates actions
- **Security lead:** technical actions and containment; validates evidence sources
- **Engineering/Operations:** executes containment and recovery actions
- **Comms lead:** internal/customer messaging and update cadence
- **Legal/Privacy:** notification timelines, contractual considerations, and scope language
- **Observers:** note gaps, missing evidence, and follow-ups (no debate in the moment)

## Role cards (copy/paste)

### Incident commander (IC)
- Owns decisions and sets the cadence.
- Declares severity and escalation.
- Approves high-impact containment actions.
- Ensures a timeline is captured in real time.

### Security lead
- Drives containment and investigation actions.
- Identifies what logs/exports should be preserved.
- Advises on risk trade-offs (containment vs availability).

### Engineering/Operations
- Executes technical actions safely (rollbacks, restores, config changes).
- Provides operational status and timelines.
- Captures evidence for changes (tickets, approvals, deploy logs).

### Comms lead
- Drafts internal and customer updates.
- Ensures language is scoped and avoids over-commitments.
- Sets update cadence and channels (status page, email, support).

### Legal/Privacy (optional)
- Advises on notification triggers and contractual obligations.
- Helps scope communications language and timelines.
- Reviews “agreement-required” sharing (reports, sensitive artifacts).

## What “good” looks like
- Clear decision ownership (someone can say “yes/no”).
- A consistent comms cadence (who updates whom, when).
- Evidence preservation mindset (export/log first, screenshots only when needed).

## Inject examples (copy/paste)
- “A customer asks for an update in 30 minutes. What do you say?”
- “A journalist emails asking if you were breached.”
- “The IdP shows multiple failed logins from new regions.”
- “Your vendor says ‘impact is limited’ but can’t confirm scope yet.”
- “Engineering says the fix requires a risky change. Who approves?”

## How to use the inject library
Use `injects-library.csv` as a pick-list:
1) Choose 5–8 injects that fit your scenario.
2) Pre-load inject IDs into `session-timeline-template.csv`.
3) During the exercise, record decision ownership and evidence captured for each inject.

## What to record (minimum)
- Decisions (what/why)
- Actions taken (who/when)
- Evidence artifacts produced (logs, exports, approvals)
- Gaps identified: remediation tasks (owner and due date)

## Prompting questions (to keep the exercise useful)
- What is the first irreversible action we would take?
- What are we assuming, and how would we validate it?
- What evidence do we want to preserve before making changes?
- Who needs to be informed, and what cadence is appropriate?
