# Metrics and scoring (optional but useful)

Use this rubric to score tabletop execution consistently and show improvement over time. The goal is learning, not performance theater.

## How to score
For each category, score 0–3:
- **0**: Missing / unclear
- **1**: Exists but inconsistent
- **2**: Mostly consistent; minor gaps
- **3**: Clear, repeatable, and evidenced

Record scores in your After-Action Report.

## Categories

### 1) Incident declaration and severity
Score based on:
- Clear trigger for incident declaration
- Severity classification is understood and used
- Escalation rules are defined and followed

### 2) Ownership and decision-making
Score based on:
- Incident commander has clear authority
- Decision ownership is explicit
- Engineering/security/comms roles are clear

### 3) Containment and recovery planning
Score based on:
- First actions are clear and prioritized
- Recovery plan considers business impact and dependencies
- Risky changes have an approval path

### 4) Evidence preservation
Score based on:
- Exports/logs are preserved before changes
- Evidence IDs are assigned (or at least referenced)
- A timeline record is produced during the session (not after)

### 5) Communications
Score based on:
- Update cadence is set early
- Internal updates are structured and consistent
- Customer language is scoped and avoids over-commitments

### 6) Follow-through
Score based on:
- Gaps become remediation tasks with owners and due dates
- Closure evidence is defined up front
- Remediation is reviewed and closed on cadence

## Benchmarking tip
Repeat the same scenario every 6 months with the same rubric. Improvement is easiest to show when you keep the scoring method constant.

