# Artifact ID naming guide

A stable artifact ID scheme reduces reviewer confusion and prevents “where is that PDF?” follow-ups. It also makes it easier to provide deltas.

## Recommended prefixes
Use prefixes that match reviewer mental models:
- `OVR-`: executive overview and scope
- `ARC-`: architecture and data flow
- `GOV-`: governance, policies, approvals
- `IAM-`: identity and access
- `LOG-`: logging and monitoring
- `SDLC-`: secure software development lifecycle (SDLC) and change management
- `VULN-`: vulnerability management
- `IR-`: incident response and exercises
- `VND-`: vendor management and subprocessors
- `BCDR-`: business continuity and disaster recovery (BCDR)
- `PRV-`: privacy and data handling

## ID format
Pick one consistent format:
- `IAM-001`, `IAM-002`, ...
- Keep IDs stable across deals (don’t renumber every time).
- When evidence changes, keep the ID and update the captured date.

## Folder structure (optional)
If you share a ZIP, keep folders simple:
- `00_index/`
- `01_overview/`
- `02_identity/`
- `03_logging/`
- `04_incident_response/`
- `05_sdlc/`
- `06_vendors/`
- `07_reports/` (agreement-required)

## Tiering (to reduce friction)
Label artifacts by tier:
- Public: early-stage shareable docs
- Gated: sensitive operational docs shared under controlled access
- Agreement-required: SOC 2 (System and Organization Controls) reports, penetration test summaries, etc.

## Notes
- Naming conventions are informational and not legal advice.
- Keep IDs short, stable, and referenced everywhere (answers, index, emails).
