# Reviewer Export Template (Fill-In)

Use this file as a starting point for a reviewer-ready export you can save as a PDF.
The structure matches how reviewers work: scope, claims, evidence, exceptions, and next steps.

Replace placeholders in `{braces}` and cite Evidence IDs throughout.
If a claim matters, it needs an evidence citation.

## How to Use This Template (Recommended)
1) Fill scope and contacts first.
2) Build the reviewer index (Evidence IDs and capture dates) before writing long answers.
3) Write short, precise answers with evidence citations.
4) List exceptions only if needed (owner and target date).
5) Save as a PDF and share one link (avoid attachments).
6) Respond to follow-ups with deltas (new Evidence IDs), not full resends.

## Conventions (What Makes This Reviewer-Friendly)
- **Scope is explicit**: product, environment, timeframe, and exclusions.
- **Evidence is indexable**: every artifact has an Evidence ID, capture date, and owner.
- **Freshness is visible**: include capture dates and cadence; mark stale items.
- **Sensitive artifacts are gated**: agreement-required reports should not be emailed.
- **No marketing language**: reviewers want verifiable claims, not adjectives.

## 1) Executive Summary (One Page)
**Product:** {Product}

**Scope date:** {YYYY-MM-DD}

**Primary security contact:** {security@yourcompany.example}

**What is included:**
This export contains a scoped security overview and a reviewer index. Each material claim cites Evidence IDs with capture dates.

**How to request more evidence:**
Reply with the question IDs or Evidence IDs you need. For agreement-required reports, request access under the agreement tier instead of email.

**Definition of done (for this review):**
- Scope is explicit and consistent.
- Material claims have citations.
- Evidence capture dates and cadence are present.
- Exceptions (if any) are owned and time-boxed.

## 2) Scope and Boundaries (Required)
Fill this section even if you include the same scope text elsewhere.
Reviewers use it to interpret every claim.

- In-scope environments: {Production only / Production and staging / etc.}
- In-scope identity: {Workforce / Customer / Both}
  - If customer authentication is customer-managed, state it explicitly.
- Data categories (high level): {Customer metadata / customer content / etc.}
- Regions/providers: {Cloud provider and regions}
- Exclusions: {Explicit exclusions}

## 3) Reviewer Index (Required)
Include an index table (or attach `05-reviewer-index-template.csv`).
This is what reviewers use to sample evidence without meetings.

Minimum per artifact:
- Evidence ID
- Artifact name
- Capture date
- Cadence (Quarterly / Monthly / On change / Annual)
- Owner
- Sensitivity/gating (Public / Verified / Agreement required)

**Example index excerpt (sanitized):**
| Evidence ID | Artifact | Captured | Cadence | Owner | Tier |
| --- | --- | --- | --- | --- | --- |
| IAM-010 | MFA enforcement export | 2026-01-02 | Quarterly | Security | Verified |
| LOG-010 | Admin audit log excerpt | 2026-01-03 | Quarterly | Security | Verified |
| SDLC-002 | Deploy approval trail excerpt | 2026-01-03 | Quarterly | Engineering | Verified |
| VND-001 | Subprocessor list | 2026-01-02 | Quarterly | Compliance | Public |

## 4) Controls Overview (Short)
Summarize in 6 to 12 bullets. Each bullet maps to Evidence IDs.
Keep claims tight and scoped.

- Identity: {short claim} (Evidence: IAM-010, IAM-002)
- Logging/monitoring: {short claim} (Evidence: LOG-001, LOG-010)
- Software delivery: {short claim} (Evidence: SDLC-001, SDLC-002)
- Incident response: {short claim} (Evidence: IR-001, IR-010)
- Vendor management: {short claim} (Evidence: VND-001, VND-010)

## 5) Common Reviewer Questions (Optional, But Reduces Follow-Ups)
Use this answer structure. It reduces follow-ups because reviewers can validate quickly.

### Answer Block Template
**Question:** {Reviewer question}

**Scope:** {What is covered and excluded, in 1 to 3 sentences.}

**Answer:** {2 to 6 sentences. Precise language. No marketing claims.}

**Evidence (Evidence IDs and capture dates):**
- {Evidence ID} - {Artifact} - captured {YYYY-MM-DD}
- {Evidence ID} - {Artifact} - captured {YYYY-MM-DD}

**Exceptions (only if needed):** {Owner, target date, compensating controls.}

### Example Answer (Sanitized)
**Question:** Do you enforce multi-factor authentication (MFA) for administrative access?

**Scope:** This applies to workforce administrative access for production systems. Customer authentication may be customer-managed depending on deployment.

**Answer:** MFA is required for privileged workforce roles. Privileged membership is tracked and reviewed on a quarterly cadence.

**Evidence:** IAM-010 (MFA enforcement export, captured 2026-01-02); IAM-003 (privileged role inventory, captured 2026-01-02).

## 6) Exceptions and Roadmap (Only If Needed)
List gaps explicitly using `07-exceptions-template.md`.
Reviewers prefer a clear, time-boxed plan over vague language.

Minimum per exception:
- The gap (what is missing)
- Owner
- Target date
- Compensating controls
- Evidence you will provide when closed (Evidence ID)

## 7) Contacts and Next Steps
- How to request additional artifacts:
  - Reply with question IDs or Evidence IDs.
- Expected response cadence:
  - {for example, 24 to 48 hours for standard follow-ups, same day for urgent deadlines}
- Agreement-required artifacts process:
  - {for example, legal contact and a logged access window}

## 8) Delta Update Template (Copy/Paste)
Use this to respond to follow-ups without resending the entire export.

```text
Subject: Evidence update - {Buyer name} review - delta {YYYY-MM-DD}

Hi {Name},

Sharing a small delta update:
- Added Evidence ID {ID} ({artifact}, captured {YYYY-MM-DD})
- Updated Evidence ID {ID} ({artifact}, refreshed {YYYY-MM-DD})

If you need anything else, reply with the question IDs or Evidence IDs and we’ll send another delta.

Thanks,
{Name}
{Role}
```

## Notes
- This template is informational and is not legal advice.
- Keep it scoped and cite Evidence IDs; avoid marketing language.

