# Sharing Templates (Email and Follow-Ups)

Use these templates to keep the security review moving without creating attachment confusion. Replace placeholders in `{braces}`.

## Template A: Initial Send (Procurement or Security Reviewer)

Subject: Security review export for {Company} and {Your product} (scope and reviewer index included)

Hi {Name},

Thanks for the security review request. To make this easy to validate, we shared a reviewer-ready export with:
- Scope and system context
- A reviewer index that maps questions to Evidence IDs
- Timestamped artifacts with owners and refresh cadence

Access: {Trust Center or deal room link}

Notes:
- If you need additional artifacts, reply with the question IDs or Evidence IDs you want. We will provide deltas instead of resending full exports.
- For sensitive reports (SOC 2, penetration test summaries), we can gate access behind an agreement and time window.

Best,
{Your name}
{Title}
{Email}

## Template A2: Agreement-Required Artifact Request (SOC 2 or Penetration Test)

Subject: Re: {Company} security review - agreement-required artifacts

Hi {Name},

We can provide the requested report(s) under agreement:
- {SOC 2 report / penetration test executive summary}

To keep sharing controlled, we will gate access behind:
- An NDA or agreement (if not already in place)
- A time window (access expires on {date})
- Access logging (who accessed what and when)

If you can confirm the right legal contact for the agreement, we will send the access request today.

Best,
{Your name}

## Template B: Follow-Up (Missing Artifact or Clarification)

Subject: Re: Security review export - follow-up on {Question ID / Evidence ID}

Hi {Name},

Quick follow-up on {Question ID / Evidence ID}.

- Current status: {Not started / In progress / Ready}
- Expected delivery: {Date}
- Notes: {Short explanation; if blocked, specify what is needed}

If you can confirm whether {scope detail} is in scope for the review, we can prioritize the remaining artifacts accordingly.

Best,
{Your name}

## Template C: Delta Update (New Artifact Added)

Subject: Security review export update - added {Evidence ID}

Hi {Name},

We added a delta update:
- {Evidence ID}: {Artifact name} (captured {YYYY-MM-DD})

Link: {Trust Center or deal room link}

Best,
{Your name}

## Template D: Close-Out (Review Complete)

Subject: Re: Security review - next steps and refresh cadence

Hi {Name},

Thanks for completing the review. For future refreshes:
- Evidence artifacts are captured on a {quarterly/monthly} cadence unless otherwise noted in the reviewer index.
- If you need an updated artifact, reply with the Evidence IDs and we will provide deltas.

If you want a standing refresh window for agreement-required artifacts, we can set that up under the same access controls (time window and access logging).

Best,
{Your name}

