# Common Buyer Questions (And What Evidence To Attach)

Use this list to reduce back-and-forth. For each question:
- Answer in 2 to 4 sentences (avoid essays).
- Attach one strong artifact (export, log, report) when possible.
- Cite it by Evidence ID in your reviewer index.

Tip: When a question is sensitive (audit reports, penetration tests), respond with “available under agreement” and gate access rather than refusing.

## Answer Format (Recommended)
Use this structure to reduce follow-ups:
1) Scope: what this answer applies to (product, environment, workforce versus customer identity)
2) Answer: what you do (short)
3) Evidence: Evidence IDs and capture dates
4) Exceptions: only if needed, with owner and target date

## Access and Identity
- Do you enforce multi-factor authentication (MFA) for all users? → MFA enforcement export or log and a policy excerpt
- Do you support single sign-on (SSO)? → SSO configuration evidence and role-based access control (RBAC) overview
- How do you handle onboarding and offboarding? → process document and example audit log or ticket record
- How is privileged access granted? → break-glass or admin access process and audit trail excerpt

## Data Protection
- Is data encrypted in transit and at rest? → security overview and platform encryption statement
- What is your retention and deletion policy? → policy and operational process notes
- How do you handle backups? → backup and recovery summary and cadence
- Where is customer data stored and processed? → data residency statement and architecture diagram

## Logging and Response
- What do you log and for how long? → logging policy and retention configuration evidence
- Do you have an incident response plan? → playbook and After-Action Report (AAR) template
- Have you had incidents? → (if yes) summary and lessons learned; (if no) tabletop exercise record
- How do you detect suspicious activity? → alerting and on-call policy and routing summary

## Secure Software Delivery
- Do you have code review and deployment controls? → branch protection evidence and deployment approval record
- How do you handle vulnerabilities? → vulnerability management cadence and example remediation workflow
- How do you restrict production access? → access model and audit logging evidence

## Privacy (Common in Enterprise Procurement)
- Do you have a data processing addendum (DPA) available? → DPA template (via legal) and contact
- Do you support data subject access requests (DSARs) where applicable? → DSAR workflow summary and ticketing evidence (sanitized)
- What data categories do you collect and store? → data inventory summary and scope statement

## Resiliency and Availability (When Buyers Care About Uptime)
- Do you have recovery time objective (RTO) and recovery point objective (RPO) targets? → business continuity and disaster recovery plan excerpt and restore test record (sanitized)
- Do you test restores? → restore test record and follow-ups
- How do you communicate outages? → status page cadence and internal communications template

## Third Parties
- Who are your subprocessors? → subprocessor list
- How do you review vendors? → vendor workflow and example due diligence export structure

## Trust and Sharing
- Can we self-serve documents? → Trust Center or deal room link with tiering and expiry
- Can you show who accessed the artifacts? → access log export (viewer, timestamp, artifact)

## Hard Questions (Handle With Scope and Gating)
- “Send us your SOC 2 (System and Organization Controls) report.” → available under agreement; provide scope statement and access window
- “Send your penetration test report.” → share under agreement; avoid raw exploitation details
- “Guarantee no data exposure ever occurs.” → do not guarantee; explain prevention, detection, and response approach with evidence

