# Evidence Checklist (Security Reviews)

Use this checklist to assemble a reviewer-ready export quickly. The goal is not perfect compliance. The goal is evidence a reviewer can verify.

## The “Verifiable Evidence” Rule
For each reviewer question, aim to provide:
1) A short answer (what you do).
2) A citation (Evidence ID).
3) A capture date and freshness window (when it was captured, and how often it is refreshed).
4) A scope note (what system, product, or environment it covers).

## Evidence Strength Hierarchy (Prefer Top to Bottom)
1) Export, log, or report from a system of record (best)
2) Configuration dump (machine-readable)
3) Screenshot (only when exports are not available)
4) Narrative-only answer with no evidence (avoid)

## Artifact Metadata to Capture
Every artifact you share should have:
- Evidence ID (for example, `IAM-001`)
- Owner (person or team)
- Capture date
- Refresh cadence (monthly, quarterly, annual, or “on change”)
- Scope (what it covers)
- Sensitivity (public, verified, agreement-required)

## Minimum Viable Export (Fast Path)
If you have a few hours, prioritize:
- Scope statement and contacts (`00-scope-and-contacts-template.md`)
- Reviewer index (`05-reviewer-index-template.csv`)
- Multi-factor authentication (MFA) enforcement evidence (`IAM-001`)
- Logging retention evidence (`LOG-001`)
- Incident response plan (`IR-001`)
- Subprocessor list (`VND-001`)

Ship once, then handle follow-ups as deltas.

## 1) Program Overview (One Page)
- Scope: what product(s) and environment(s) are covered
- Security owner(s) and escalation contacts
- High-level architecture and data flows (a simple diagram is enough)
- Customer data types handled (for example, personal data, health data, or payment data)

Strong evidence examples:
- A one-page security overview with date and contacts
- A diagram excerpt with data flow notes (sanitized)

## 2) Governance Core
- Written information security program (WISP) or equivalent
- Core policies (access control, incident response, vendor management, and data retention)
- Policy approval and review history (timestamps and approvers)
- Exception and risk acceptance log (even if small)

Strong evidence examples:
- Policy index with last updated dates
- Approval or version history excerpt (document management export)

## 3) Access Control
- Single sign-on (SSO) and multi-factor authentication (MFA) policies, plus enforcement evidence
- Role-based access control (RBAC) overview (roles and what they can do)
- Joiner, mover, leaver process (document and evidence of execution)
- Privileged access process (break-glass, approvals, and audit trail)

Strong evidence examples:
- Identity provider (IdP) export showing MFA enforcement for workforce accounts
- Privileged role inventory and access review record

## 4) Logging, Monitoring, and Response
- Audit logging coverage (what is logged, retention, and access controls)
- Alerting and on-call process (even if lightweight)
- Incident response playbook and example incident record format
- Tabletop exercise record (date, attendees, outcomes, action items)

Strong evidence examples:
- Log retention configuration export and who can access logs
- Alert routing summary tied to on-call ownership

## 5) Change Management and Software Delivery
- Pull request (PR) review policy and branch protections
- Continuous integration and continuous delivery (CI/CD) controls (who can deploy, approvals, audit trail)
- Vulnerability management process (tooling and cadence)
- Production access restrictions (who can access production, how, and how it is logged)

Strong evidence examples:
- Branch protection rules and required review settings
- Example deployment approval record (redacted)

## 6) Data Protection
- Encryption in transit and at rest (statement and evidence where available)
- Backups and recovery expectations
- Data retention and deletion policy
- Data residency (if applicable): where data is stored and processed

Strong evidence examples:
- Encryption model summary with configuration evidence (where available)
- Backup verification logs or restore test record (sanitized)

## 7) Vendor and Subprocessor Oversight
- Vendor inventory (especially those touching customer data)
- Subprocessor list and review cadence
- Example vendor due diligence export structure
- Renewal and re-review triggers (material change, incident, renewal)

Strong evidence examples:
- Subprocessor list with data categories and update cadence
- Vendor decision log excerpt (approve or approve with conditions)

## 8) People Readiness (Often Overlooked)
- Security awareness training completion export
- Policy acknowledgments export (if applicable)
- Tabletop exercise record or After-Action Report (AAR) format
- Phishing simulation outcomes (if used)

## 9) Business Continuity and Resiliency (If Asked)
- Recovery time objective (RTO) and recovery point objective (RPO) targets (even approximate), and how they are tested
- Backup verification or restore test record
- Incident communications cadence (internal and customer)

## 10) Third-Party Validation (Include What You Have)
- SOC 2 (System and Organization Controls) report (if available)
- Penetration test summary (if available)
- Other attestations (as applicable)

## Packaging Checklist (Before You Share)
- [ ] Index first: the reviewer should not hunt through folders.
- [ ] Every artifact has an Evidence ID, capture date, cadence, owner, and scope notes.
- [ ] Sensitive artifacts are gated and logged (agreement-required by default).
- [ ] No internal hostnames, account IDs, or secrets in shared exports.
- [ ] Exceptions (if any) are explicit and time-boxed.
